<?php

namespace App\Controllers;


class ConsultaDni extends BaseController
{
    public function buscar()
    {
        $request = \Config\Services::request();
        $dni = $request->getVar('numero');

        if (!$dni) {
            return $this->response->setJSON(['error' => 'DNI no proporcionado']);
        }

        $token = 'apis-token-1.aTSI1U7KEuT-6bbbCguH-4Y8TI6KS73N';

        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get('https://api.apis.net.pe/v1/dni', [
                'headers' => [
                    'Authorization' => 'Bearer ' . $token,
                    'Referer' => 'https://apis.net.pe/consulta-dni-api',
                ],
                'query' => [
                    'numero' => $dni
                ],
                'http_errors' => false
            ]);

            $body = $response->getBody();
            $data = json_decode($body, true);

            return $this->response->setJSON($data);

        } catch (\Exception $e) {
            return $this->response->setJSON([
                'error' => 'Error en la solicitud: ' . $e->getMessage()
            ]);
        }
    }
}