<?php

namespace App\Controllers;
use App\Models\SedeModel;
use App\Models\Registro_ingresoModel;

class Registro extends BaseController
{

    private $sede;
    private $registro;

    public function __construct()
    {
        $this->sede = new SedeModel();
        $this->registro = new Registro_ingresoModel();
    }

   public function registrar()
{
    try {
        if ($this->request->getMethod() !== 'POST') {
            return $this->response->setJSON([
                'estado'  => 'error',
                'mensaje' => 'Método no permitido'
            ]);
        }

        $fechaIngreso = date('Y-m-d H:i:s', strtotime($this->request->getPost('fecha_ingreso')));

        $datos = [
            'dni'          => $this->request->getPost('dni'),
            'nombres'      => UppercaseWords($this->request->getPost('nombres')),
            'fecha_ingreso'=> $fechaIngreso,
            'id_sede'      => $this->request->getPost('sede'),
            'id_dependencia' => $this->request->getPost('dependencia'),
            'tipo_registro' => UppercaseWords($this->request->getPost('tipo_registro')),
            'persona' => UppercaseWords($this->request->getPost('persona'))  
        ];

        if ($this->registro->save($datos)) {
            return $this->response->setJSON([
                'estado'  => 'ok',
                'mensaje' => 'Registro exitoso',
                'fecha' => $fechaIngreso
            ]);
        } else {
            return $this->response->setJSON([
                'estado'  => 'error',
                'mensaje' => 'Error al guardar en la base de datos',
                'detalles'=> $this->sede->errors() // Errores de validación del modelo
            ]);
        }

    } catch (\Throwable $e) {
        // Captura errores de PHP y base de datos
        return $this->response->setJSON([
            'estado'  => 'error',
            'mensaje' => 'Ocurrió un error inesperado',
            'error'   => $e->getMessage()
        ]);
    }
}




    public function certificado()
    {
        $nombre = $this->request->getGet('nombre');
        $data=[

            'nombre'=>$nombre
        ];
        return view('main/certificado',$data);
      // echo $nombre;
    }
}
