<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <!-- MUY IMPORTANTE para responsividad -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Registro de Ingreso</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-table@1.22.1/dist/bootstrap-table.min.css">

  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

  <!-- Estilos -->
  <style>
    body {
      background-color: #062385ff;
      color: white;
      font-size: 1.2rem;
    }
    .card {
      background-color: #fff;
      color: #000;
      border-radius: 12px;
      padding: 20px;
    }
    .form-control-lg, .btn-lg {
      font-size: 1.5rem;
      padding: 2px;
    }
    .logo {
      max-width: 150px;
      margin-bottom: 20px;
    }
    button{
      margin-bottom: 2px;
    }
     #spinnerOverlay {
      /*display: none !important;*/
    }

    #nombre_sede{

      font-size: 40px;
      font-weight: bold;
      color: #000;
    }
    
   .mb-3{
      margin-bottom: 1px !important;
      margin-top: 1px !important;
      font-size: 15px !important;
   }

  </style>
</head>

<body class="d-flex flex-column align-items-center justify-content-start min-vh-100">

  <!--div class="text-center mt-3">
    <img src="./assets/img/Poder_Judicial_del_Peru.png" alt="Logo" class="logo img-fluid">
  </div>

  <h2 class="text-center mt-3">Sistema de Registro de Ingresantes</h2-->

  <div class="container" style="max-width: 500px; margin-top: 100px;">


    <!-- Mensaje de éxito -->
<?php if (session()->getFlashdata('success')): ?>
    <?= session()->getFlashdata('success') ?>
<?php endif; ?>

<!-- Mensajes de error de validación -->
<!-- Mostrar error general -->
<?php if (isset($error)): ?>
    <div class="alert alert-danger" role="alert">
        <p><?= esc($error) ?></p>
    </div>
<?php endif; ?>

<?php if (isset($validation) && $validation->getErrors()): ?>
    <div class="alert alert-danger" role="alert">
        <?= $validation->listErrors() ?>
    </div>
<?php endif; ?>

  <div class="card shadow p-4">
    
    <div class="d-grid gap-3">
      <form method="POST" action="<?= base_url('admin/usuarios/registrar') ?>">
  <div class="mb-3">
    <label for="usuario" class="form-label">Usuario</label>
    <input type="text" class="form-control" id="id_usuario" name="id_usuario" required>
  </div>

  <div class="mb-3">
    <label for="nombres" class="form-label">Nombre completo</label>
    <input type="text" class="form-control" id="nombres" name="nombres" required>
  </div>
 

  <div class="mb-3">
    <label for="clave" class="form-label">Contraseña</label>
    <input type="password" class="form-control" id="clave" name="clave" required>
  </div>
  <div class="mb-3">
    <label for="clave" class="form-label">Confirmar Contraseña</label>
    <input type="password" class="form-control" id="confirmar" name="confirmar" required>
  </div>

  <div class="mb-3">
    <label for="rol" class="form-label">Seleccionar Rol</label>
    <select class="form-select" id="roles" name="roles" required>
      <?php foreach ($roles as $rol) { 
        ?>
        <option value="<?= esc($rol['id_rol']) ?>"><?= esc($rol['nombre']) ?></option>
      <?php } ?>
      <!-- Agregar más sedes dinámicamente desde PHP -->
    </select>
  </div>

  <div class="mb-3">
    <label for="sede" class="form-label">Sede</label>
    <select class="form-select" id="sede" name="sede" required>
      <?php foreach ($sede as $s) { 
        ?>
        <option value="<?= esc($s['id_sede']) ?>"><?= esc($s['nombre']) ?></option>
      <?php } ?>
      <!-- Agregar más sedes dinámicamente desde PHP -->
    </select>
  </div>

  <button type="submit" class="btn btn-success btn-lg w-100 mb-2">
    <i class="bi bi-person-plus me-2"></i>Crear Usuario
  </button>
  <a href="<?=base_url()?>" class="btn btn-danger btn-lg w-100">
    Cancelar
  </a>
</form>

    </div>

  </div>
</div>
 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Librería QR/Barcode -->
  <script src="https://unpkg.com/html5-qrcode"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  </body>
  </html>