<?php

namespace App\Controllers;

use App\Models\SedeModel;
use App\Models\Registro_ingresoModel;
use App\Models\DependenciaModel;

class Home extends BaseController
{
    private $sede;
    private $registroingreso;
    private $dependencias;
    protected $sesion;


public function __construct()
    {
        $this->sede = new SedeModel();
        $this->registroingreso = new Registro_ingresoModel();
        $this->dependencias = new DependenciaModel();
        $this->sesion = session();
    }

    public function index()
    {
        
            return redirect()->to(base_url('/registro'));
       
    }

    public function registro()
    {
        $sede=$this->sede->where('id_sede',$this->sesion->get('id_sede'))->first();
        $dependencia=$this->dependencias->findAll();
        
        
        $data=['sede'=>$sede,
               'dependencia'=>$dependencia];
        return view('template/header').
         view('main/registro',$data);
    }

    public function busqueda(): string
    {
        $ri = $this->registroingreso
                ->select('registro_ingreso.*, sede.nombre AS nombre_sede')
                ->join('sede', 'sede.id_sede = registro_ingreso.id_sede', 'left')
                ->findAll();
        $data=['registros'=>$ri];
        return view('template/header').
         view('main/busqueda',$data);
    }

    public function login(): string
    {
         return view('main/login');
    }

    public function logout()
    {
        $this->sesion->destroy();
        return redirect()->to(base_url('/'));
    }

   
}
