<?php

namespace App\Controllers;

use App\Models\SedeModel;

class Sesion extends BaseController
{
    private $sede;


public function __construct()
    {
        $this->sede = new SedeModel();
        
    }



    public function validar()
    {
        $usuarioModel = new UsuarioModel();

        $usuario = $this->request->getPost('usuario');
        $clave   = $this->request->getPost('clave');

        $user = $usuarioModel->where('usuario', $usuario)->first();

        if ($user && password_verify($clave, $user['clave'])) {
            
            
            generarToken($user['id_usuario']);

            // Guardar en sesión de CI
            session()->set([
                'usuario_id'        => $user['id_usuario'],
                'usuario_nombre'    => $user['nombres'],
                'logueado'          => true
            ]);

            return redirect()->to('/dashboard');
        } else {
            return redirect()->back()->with('error', 'Usuario o contraseña incorrectos');
        }
    }

    public function logout()
    {
        session()->destroy();
        setcookie('token_sistema', '', time() - 3600, "/");
        return redirect()->to('/login');
    }
}
