 <!-- spinner-->
<div id="spinnerOverlay" class="position-fixed top-0 start-0 w-100 h-100 d-flex justify-content-center align-items-center bg-dark bg-opacity-50 d-none" style="z-index: 1050;">
  <div class="spinner-border text-light" role="status">
    <span class="visually-hidden">Cargando...</span>
  </div>
</div>

<!-- termina spinner-->

  <!-- Formulario -->
  <div class="container" style="max-width: 500px; margin-top: 210px;">
    <div class="card shadow">
        <div class="mb-0 text-center">
            <label id="nombre_sede" class="form-label fw-bold"><?= esc($sede['nombre'])?></label>
            
        <input type="hidden" id="sede" value="<?= esc($sede['id_sede'])?>">
        </div>

        
     <div class="d-flex justify-content-center gap-3 mb-3 mt-3">
  <input type="radio" class="btn-check" name="tipo_registro" id="tipo_ingreso" autocomplete="off" checked>
  <label class="btn btn-outline-success flex-fill text-center" for="tipo_ingreso">INGRESO</label>

  <input type="radio" class="btn-check" name="tipo_registro" id="tipo_salida" autocomplete="off">
  <label class="btn btn-outline-danger flex-fill text-center" for="tipo_salida">SALIDA</label>
</div>

        

      <div class="mb-1 text-center">
        <label for="dni" class="form-label fw-bold">Ingrese número de DNI: </label>
        <div class="input-group input-group-lg">

        <input type="text" id="dni" class="form-control form-control-lg" placeholder="Ingrese DNI" 
        maxlength="8" 
        minlength="8" 
        pattern="\d{1,8}" 
        required 
        title="Ingresa hasta 8 dígitos numéricos">
          <button class="btn btn-danger btn-lg" type="button" data-bs-toggle="modal" data-bs-target="#modalScanner">
            <i class="bi bi-upc-scan"></i>
          </button>
        </div>
      </div>

      <!-- Datos -->
      <div id="datosUsuario" class="mt-4 d-none">
        <p><strong>DNI:</strong> <span id="dniText"></span></p>
        <p><strong>Nombre:</strong> <span id="nombreText"></span></p>
        <div class="text-center mt-4">

        <div class="mt-3 mb-3">
  <label for="dependencia" class="form-label"><strong>Dependencia</strong></label>
  <select class="form-select" name='dependencia' id="dependencia">
    <?php foreach($dependencia as $dep){ ?>  
      <option value="<?= esc($dep['id_dependencia']);?>"><?= esc($dep['nombre']);?></option>
    <?php } ?>
  </select>
</div>
          
      <div class="d-flex justify-content-center gap-3 mb-3 mt-3">
  <input type="radio" class="btn-check" name="persona" id="persona_interno" autocomplete="off">
  <label class="btn btn-outline-primary flex-fill text-center" for="persona_interno">INTERNO</label>

  <input type="radio" class="btn-check" name="persona" id="persona_externo" autocomplete="off" checked>
  <label class="btn btn-outline-primary flex-fill text-center" for="persona_externo">EXTERNO</label>
</div>






          <button class="btn btn-success btn-lg w-100" id="registrar">Registrar</button>
          
          <button class="btn btn-danger btn-lg w-100"id="limpiar">Limpiar Campos</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal Lector -->
  <div class="modal fade" id="modalScanner" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content bg-dark text-white">
        <div class="modal-header">
          <h5 class="modal-title">Escanear código</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body text-center">
          <!--div id="reader" style="width:100%;"></div-->
          <video id="reader" style="width:100%; height:auto;" autoplay muted playsinline></video>
          <div id="scan-area"></div>
        </div>
      </div>
    </div>
</div>

 <div class="modal fade" id="modalExito" tabindex="-1" aria-labelledby="modalExitoLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-success">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title" id="modalExitoLabel">✅ Registro Exitoso</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body text-black">
        <label id="hora_registro" style="font-size: 40px;">Hora de registro:</label>
      </div>
    </div>
  </div>
</div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Librería QR/Barcode -->
  <!--script src="https://unpkg.com/html5-qrcode"></script-->
  <script src="https://unpkg.com/@zxing/browser@latest"></script>
<script>
  const { BrowserMultiFormatReader, BrowserCodeReader, NotFoundException } = ZXingBrowser;
</script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>

    const modalScanner = document.getElementById('modalScanner');
    
    /*let html5QrCode;

    // Inicia el escáner al abrir el modal
    modalScanner.addEventListener('shown.bs.modal', () => {
      html5QrCode = new Html5Qrcode("reader");
      html5QrCode.start(
        { facingMode: "environment" }, // Cámara trasera
        { fps: 15, qrbox: 250 },
        (decodedText) => {
          playBeep()  
          buscarDni(decodedText);

          const modal = bootstrap.Modal.getInstance(modalScanner);
          modal.hide();
          html5QrCode.stop();
        },
        (errorMessage) => {}
      ).catch(err => {
        console.error("Error iniciando cámara: ", err);
      });
    });

    // Detener escáner al cerrar modal
    modalScanner.addEventListener('hidden.bs.modal', () => {
      if (html5QrCode) {
        html5QrCode.stop().catch(err => console.error("Error deteniendo cámara:", err));
      }
    });*/

 
  let codeReader;

  // Al abrir el modal
  modalScanner.addEventListener('shown.bs.modal', async () => {
    codeReader = new BrowserMultiFormatReader();

    try {
      // Listar cámaras disponibles
      const devices = await BrowserCodeReader.listVideoInputDevices();

      // Buscar cámara trasera
      let backCamera = devices.find(d => d.label.toLowerCase().includes('back'));
      if (!backCamera) backCamera = devices[0]; // fallback a la primera

      // Iniciar escaneo
      await codeReader.decodeFromVideoDevice(
        backCamera.deviceId,
        'reader',
        (result, err) => {
          if (result) {
            console.log("Código detectado:", result.getText());
            playBeep(); // tu función de sonido
            buscarDni(result.getText()); // tu lógica

            // Cerrar modal
            const modal = bootstrap.Modal.getInstance(modalScanner);
            modal.hide();

            // Detener cámara
            codeReader.reset();
          }
          // ⚠️ Los errores de "no detectado" se ignoran
        }
      );
    } catch (err) {
      console.error("Error iniciando cámara:", err);
    }
  });

  // Al cerrar modal
  modalScanner.addEventListener('hidden.bs.modal', () => {
    if (codeReader) {
      codeReader.reset();
    }
  });


    // Ingreso manual
    document.getElementById('dni').addEventListener('change', function() {
      
      const dni = this.value.trim();
      if (dni) {
      buscarDni(dni);
      }
     
    });

  function limpiar() {

            document.getElementById('dni').value = "";
            document.getElementById('dniText').textContent = "";
            document.getElementById('nombreText').textContent = "";
            document.getElementById('datosUsuario').classList.add('d-none');
            ocultarSpinner();

  }

   document.getElementById('limpiar').addEventListener('click', function() {
      limpiar();
            
          });       
          
    function buscarDni(dni){

        document.getElementById("spinnerOverlay").classList.remove("d-none");
       
      fetch(`<?= base_url('registro/consultadni')?>?numero=${dni}`)
        .then(response => response.json())
        .then(data => {
          if (data.error) {
            alert(data.error);
             ocultarSpinner();
            return;
           
          }

          
          const nombreCompleto = data.nombre;
          document.getElementById('dniText').textContent = dni;
            document.getElementById('nombreText').textContent = data.nombre;
            document.getElementById('datosUsuario').classList.remove('d-none');
            
ocultarSpinner();
      
        })
        .catch(error => {
          alert("Ocurrió un error al buscar el Dni.");
          ocultarSpinner();
          console.error(error);
        });

    }


document.getElementById('registrar').addEventListener('click', function () {
    // Mostrar el spinner
    document.getElementById("spinnerOverlay").classList.remove("d-none");

    let fecha = new Date();
    let fecha_ingreso = new Date(fecha.getTime() - (5 * 60 * 60 * 1000));
    
    // Crear FormData y agregar campos
    let formData = new FormData();
    formData.append('dni', document.getElementById('dniText').textContent.trim());
    formData.append('nombres', document.getElementById('nombreText').textContent.trim());
    formData.append('fecha_ingreso', fecha_ingreso.toISOString()); 
    formData.append('sede', document.getElementById('sede') ? document.getElementById('sede').value : '0');
    formData.append('dependencia', document.getElementById('dependencia').value);
    formData.append('tipo_registro',document.getElementById('tipo_ingreso').checked ? 'ingreso' : 'salida');
    formData.append('persona',document.getElementById('persona_interno').checked ? 'interno' : 'externo');

    
    fetch('<?= base_url('registro/registrarconsulta')?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        console.log('Respuesta del servidor:', data);

        // Ocultar spinner
        document.getElementById("spinnerOverlay").classList.add("d-none");

        if (data.estado === 'ok') {
           /* document.getElementById("hora_registro").textContent = 'Hora de Registro: '+data.fecha;
            mostrarModal();*/
            mostrarAlerta(data);
            
        } else {
            alert('❌ ' + data.mensaje);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById("spinnerOverlay").classList.add("d-none");
        alert('Ocurrió un error en la conexión');
    });
});

function mostrarModal(){
    const modalExito = new bootstrap.Modal(document.getElementById("modalExito"));
    modalExito.show();

    setTimeout(() => {
          modalExito.hide();
          limpiar();
        }, 2000);
}

  
function ocultarSpinner() {
  document.getElementById("spinnerOverlay").classList.add("d-none");
}

function playBeep() {
    const ctx = new (window.AudioContext || window.webkitAudioContext)();
    const oscillator = ctx.createOscillator();
    const gainNode = ctx.createGain();

    oscillator.type = "sine"; // O "square", "triangle", "sawtooth"
    oscillator.frequency.setValueAtTime(1000, ctx.currentTime); // Frecuencia en Hz

    gainNode.gain.setValueAtTime(0.1, ctx.currentTime); // Volumen

    oscillator.connect(gainNode);
    gainNode.connect(ctx.destination);

    oscillator.start();
    oscillator.stop(ctx.currentTime + 0.1); // Duración 0.1 segundos
}

function mostrarAlerta(datos) {
      Swal.fire({
        title: 'Registro de Ingreso',
        html: `
          
          <p><strong>Hora de registro:</strong> ${datos.fecha}</p>
        `,
        icon: 'success',
        confirmButtonText: 'Aceptar',
        timer: 2000
      });
      limpiar();
    }

  </script>
</body>
</html>